/*
 * Decompiled with CFR 0.152.
 */
package cds.tools;

import cds.tools.CDSConstants;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JPanel;

public final class CDSLabel
extends JPanel
implements CDSConstants {
    static final int MARGE = 10;
    Vector line = null;
    Font font;
    FontMetrics fm;
    int mode;
    String text;
    boolean flagReaffiche = false;

    public CDSLabel() {
    }

    public CDSLabel(String text) {
        this(text, 1, PLAIN);
    }

    public CDSLabel(String text, int mode) {
        this(text, mode, PLAIN);
    }

    public CDSLabel(String text, int mode, Font font) {
        this.mode = mode;
        this.font = font;
        this.setFont(font);
        this.fm = Toolkit.getDefaultToolkit().getFontMetrics(font);
        this.setText(text);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        StringTokenizer st = new StringTokenizer(text, "\n");
        int max = 0;
        this.text = text;
        this.line = new Vector(10);
        while (st.hasMoreTokens()) {
            int w;
            String s = st.nextToken();
            StringTokenizer st1 = new StringTokenizer(s, " ", true);
            StringBuffer s1 = new StringBuffer();
            while (st1.hasMoreTokens()) {
                s1.append(st1.nextToken());
                if (s1.length() <= 80) continue;
                this.line.addElement(s1.toString());
                w = this.fm.stringWidth(s1.toString());
                if (max < w) {
                    max = w;
                }
                s1 = new StringBuffer();
            }
            if (s1.length() <= 0) continue;
            this.line.addElement(s1.toString());
            w = this.fm.stringWidth(s1.toString());
            if (max >= w) continue;
            max = w;
        }
        if (this.mode == 2) {
            max += 10;
        }
        int h = this.line.size() * 17 + 3;
        this.resize(max, h);
        this.reaffiche();
    }

    @Override
    public Dimension preferredSize() {
        return this.size();
    }

    @Override
    public Dimension getPreferredSize() {
        return this.size();
    }

    @Override
    public Dimension minimumSize() {
        return this.size();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.size();
    }

    private void reaffiche() {
        this.flagReaffiche = true;
        this.repaint();
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    @Override
    public void paint(Graphics g) {
        if (this.line == null) {
            return;
        }
        int y = 17;
        int n = this.line.size();
        int width = this.size().width;
        int height = this.size().height;
        if (this.flagReaffiche) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, width, height);
            this.flagReaffiche = false;
            g.setColor(this.getForeground());
        }
        for (int i = 0; i < n; ++i) {
            String s = (String)this.line.elementAt(i);
            int w = this.fm.stringWidth(s);
            int x = this.mode == 0 ? 0 : (this.mode == 2 ? width - w - 10 : width / 2 - w / 2);
            g.drawString(s, x, y);
            y += 17;
        }
    }
}

